/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.WithNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileSplit;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtiles;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.decoration.Rainbow;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class InstructionFork
extends WithNote
implements Instruction {
    private final List<InstructionList> forks = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;
    private final ISkinParam skinParam;
    private final Swimlane swimlaneIn;
    private Swimlane swimlaneOut;
    private ForkStyle style = ForkStyle.FORK;
    private String label;
    boolean finished = false;

    @Override
    public boolean containsBreak() {
        for (InstructionList fork : this.forks) {
            if (!fork.containsBreak()) continue;
            return true;
        }
        return false;
    }

    public InstructionFork(Instruction parent, LinkRendering inlinkRendering, ISkinParam skinParam, Swimlane swimlane) {
        this.parent = parent;
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
        this.skinParam = skinParam;
        this.swimlaneIn = swimlane;
        this.swimlaneOut = swimlane;
        this.forks.add(InstructionList.empty());
    }

    private InstructionList getLastList() {
        return this.forks.get(this.forks.size() - 1);
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.getLastList().add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        ArrayList<Gtile> all = new ArrayList<Gtile>();
        for (InstructionList list : this.forks) {
            Gtile tmp = list.createGtile(skinParam, stringBounder);
            tmp = Gtiles.withIncomingArrow(tmp, 20.0);
            tmp = Gtiles.withOutgoingArrow(tmp, 20.0);
            all.add(tmp);
        }
        return new GtileSplit(all, this.swimlaneIn, this.getInLinkRenderingColor(skinParam).getColor());
    }

    private Rainbow getInLinkRenderingColor(ISkinParam skinParam) {
        Rainbow color = Rainbow.build(skinParam);
        return color;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.forks) {
            all.add(list.createFtile(factory));
        }
        Ftile result = factory.createParallel(all, this.style, this.label, this.swimlaneIn, this.swimlaneOut);
        if (this.getPositionedNotes().size() > 0) {
            result = FtileWithNoteOpale.create(result, this.getPositionedNotes(), false, VerticalAlignment.CENTER);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void forkAgain(Swimlane swimlane) {
        this.swimlaneOut = swimlane;
        this.forks.add(InstructionList.empty());
    }

    @Override
    public final boolean kill() {
        return this.getLastList().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (this.finished) {
            return super.addNote(note, position, type, colors, swimlaneNote);
        }
        if (this.getLastList().getLast() == null) {
            return this.getLastList().addNote(note, position, type, colors, swimlaneNote);
        }
        return this.getLastList().addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>(InstructionList.getSwimlanes2(this.forks));
        result.add(this.swimlaneIn);
        result.add(this.swimlaneOut);
        return result;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlaneIn;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlaneOut;
    }

    public void manageOutRendering(LinkRendering nextLinkRenderer, boolean endFork) {
        if (endFork) {
            this.finished = true;
        }
        if (nextLinkRenderer == null) {
            return;
        }
        this.getLastList().setOutRendering(nextLinkRenderer);
    }

    public void setStyle(ForkStyle style, String label, Swimlane swimlane) {
        this.style = style;
        this.label = label;
        this.swimlaneOut = swimlane;
    }
}

