/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileMargedRight;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ConnectionVerticalDown;
import znaishaded.net.sourceforge.plantuml.decoration.Rainbow;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;

public class FtileFactoryDelegatorAssembly
extends FtileFactoryDelegator {
    public FtileFactoryDelegatorAssembly(FtileFactory factory) {
        super(factory);
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        double height = 35.0;
        TextBlock textBlock = this.getTextBlock(this.getInLinkRenderingDisplay(tile2));
        StringBounder stringBounder = this.getStringBounder();
        if (textBlock != null) {
            height += textBlock.calculateDimension(stringBounder).getHeight();
        }
        Ftile tile1andSpace = FtileUtils.addBottom(tile1, height);
        Ftile result = super.assembly(tile1andSpace, tile2);
        FtileGeometry geo = tile1.calculateDimension(stringBounder);
        if (!geo.hasPointOut()) {
            return result;
        }
        UTranslate translate1 = result.getTranslateFor(tile1andSpace, stringBounder);
        XPoint2D p1 = geo.translate(translate1).getPointOut();
        UTranslate translate2 = result.getTranslateFor(tile2, stringBounder);
        XPoint2D p2 = tile2.calculateDimension(stringBounder).translate(translate2).getPointIn();
        Rainbow color = this.getInLinkRenderingColor(tile2);
        ConnectionVerticalDown connection = new ConnectionVerticalDown(tile1, tile2, p1, p2, color, textBlock);
        result = FtileUtils.addConnection(result, connection);
        if (textBlock != null) {
            FtileGeometry dim = result.calculateDimension(stringBounder);
            double width = dim.getWidth();
            double maxX = connection.getMaxX(stringBounder);
            double needed = (maxX - width) * 2.0;
            if (width < maxX) {
                result = new FtileMargedRight(result, maxX);
            }
        }
        return result;
    }
}

