/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.skin.ColorParam;
import znaishaded.net.sourceforge.plantuml.skin.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;

public class GtileCircleSpot
extends AbstractGtile {
    private static final int SIZE = 20;
    private final String spot;
    private final FontConfiguration fc;
    private final HColor backColor;
    private double shadowing;

    private StyleSignatureBasic getDefaultStyleDefinitionCircle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.circle);
    }

    public GtileCircleSpot(StringBounder stringBounder, ISkinParam skinParam, HColor backColor, Swimlane swimlane, String spot, UFont font) {
        super(stringBounder, skinParam, swimlane);
        this.spot = spot;
        this.backColor = backColor;
        this.fc = FontConfiguration.create(skinParam, FontParam.ACTIVITY, null);
        Style style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        this.shadowing = style.value(PName.Shadowing).asDouble();
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        HColor borderColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBorder);
        HColor backColor = this.backColor == null ? SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBackground) : this.backColor;
        UEllipse circle = UEllipse.build(20.0, 20.0);
        circle.setDeltaShadow(this.shadowing);
        ug.apply(borderColor).apply(backColor.bg()).apply(this.getThickness()).draw(circle);
        ug.apply(this.fc.getColor()).apply(new UTranslate(10.0, 10.0)).draw(new UCenteredCharacter(this.spot.charAt(0), this.fc.getFont()));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(20.0, 20.0);
    }
}

