/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note.sequence;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.skin.ColorParam;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public final class FactorySequenceNoteOverSeveralCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteOverSeveralCommand.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO1", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("P1", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("P2", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO2", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteOverSeveralCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteOverSeveralCommand.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO1", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("P1", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("P2", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO2", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteOverSeveralCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram system, LineLocation location, RegexResult arg) throws NoSuchColorException {
                BlocLines strings = BlocLines.getWithNewlines(arg.get("NOTE", 0));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(system, arg, strings);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                return "^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult line0, BlocLines lines) throws NoSuchColorException {
        Participant p1 = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(line0.get("P1", 0)));
        Participant p2 = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(line0.get("P2", 0)));
        if (lines.size() > 0) {
            boolean tryMerge = line0.get("VMERGE", 0) != null;
            boolean parallel = line0.get("PARALLEL", 0) != null;
            Display display = diagram.manageVariable(lines.toDisplay());
            Note note = new Note(p1, p2, display, diagram.getSkinParam().getCurrentStyleBuilder());
            Colors colors = FactorySequenceNoteOverSeveralCommand.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
            String stereotypeString = line0.getLazzy("STEREO", 0);
            if (stereotypeString != null) {
                Stereotype stereotype = Stereotype.build(stereotypeString);
                colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
                note.setStereotype(stereotype);
            }
            note.setColors(colors);
            note.setNoteStyle(NoteStyle.getNoteStyle(line0.get("STYLE", 0)));
            if (line0.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                Url urlLink = urlBuilder.getUrl(line0.get("URL", 0));
                note.setUrl(urlLink);
            }
            if (parallel) {
                note.goParallel();
            }
            diagram.addNote(note, tryMerge);
        }
        return CommandExecutionResult.ok();
    }
}

