/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import znaishaded.net.sourceforge.plantuml.svek.Ports;

public class EntityPort {
    private final String entityUid;
    private final String portId;

    private EntityPort(String entityUid, String portId) {
        this.entityUid = entityUid;
        this.portId = portId;
    }

    public static EntityPort create(String entityUid, String portName) {
        return new EntityPort(entityUid, portName == null ? null : Ports.encodePortNameToId(portName));
    }

    public static EntityPort forPort(String entityUid) {
        return new EntityPort(entityUid, "P");
    }

    public String getFullString() {
        if (this.portId != null) {
            return this.entityUid + ":" + this.portId;
        }
        return this.entityUid;
    }

    private boolean isShielded() {
        return this.entityUid.endsWith(":h");
    }

    public String getPrefix() {
        if (this.isShielded()) {
            return this.entityUid.substring(0, this.entityUid.length() - 2);
        }
        return this.entityUid;
    }

    public boolean startsWith(String centerId) {
        return this.entityUid.startsWith(centerId);
    }

    public boolean equalsId(EntityPort other) {
        return this.entityUid.equals(other.entityUid);
    }
}

