/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.decoration.symbol;

import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractUGraphicHorizontalLine;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEmpty;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.style.SName;

class USymbolDatabase
extends USymbol {
    USymbolDatabase() {
    }

    @Override
    public SName getSName() {
        return SName.database;
    }

    private void drawDatabase(UGraphic ug, double width, double height, double shadowing) {
        UPath shape = UPath.none();
        shape.setDeltaShadow(shadowing);
        shape.moveTo(0.0, 10.0);
        shape.cubicTo(0.0, 0.0, width / 2.0, 0.0, width / 2.0, 0.0);
        shape.cubicTo(width / 2.0, 0.0, width, 0.0, width, 10.0);
        shape.lineTo(width, height - 10.0);
        shape.cubicTo(width, height, width / 2.0, height, width / 2.0, height);
        shape.cubicTo(width / 2.0, height, 0.0, height, 0.0, height - 10.0);
        shape.lineTo(0.0, 10.0);
        ug.draw(shape);
        UPath closing = this.getClosingPath(width);
        ug.apply(HColors.none().bg()).draw(closing);
        ug.apply(new UTranslate(width, height)).draw(new UEmpty(10.0, 10.0));
    }

    private UPath getClosingPath(double width) {
        UPath closing = UPath.none();
        closing.moveTo(0.0, 10.0);
        closing.cubicTo(0.0, 20.0, width / 2.0, 20.0, width / 2.0, 20.0);
        closing.cubicTo(width / 2.0, 20.0, width, 20.0, width, 10.0);
        return closing;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 24.0, 5.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolDatabase.this.drawDatabase(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                USymbol.Margin margin = USymbolDatabase.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                MyUGraphicDatabase ug2 = new MyUGraphicDatabase(ug, dim.getWidth());
                tb.drawU(ug2.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolDatabase.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolDatabase.this.drawDatabase(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 22.0)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 22.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }

    @Override
    public int suppHeightBecauseOfShape() {
        return 15;
    }

    class MyUGraphicDatabase
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicDatabase(ug, this.endingX);
        }

        public MyUGraphicDatabase(UGraphic ug, double endingX) {
            super(ug);
            this.endingX = endingX;
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UPath closing = USymbolDatabase.this.getClosingPath(this.endingX);
            ug = ug.apply(translate);
            ug.apply(line.getStroke()).apply(HColors.none().bg()).apply(UTranslate.dy(-15.0)).draw(closing);
            if (line.isDouble()) {
                ug.apply(line.getStroke()).apply(HColors.none().bg()).apply(UTranslate.dy(-13.0)).draw(closing);
            }
            line.drawTitleInternal(ug, 0.0, this.endingX, 0.0, true);
        }
    }
}

