/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.GroupType;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.svek.GroupMakerState;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierState {
    private final ICucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierState(ICucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            Collection<Entity> groups = this.getOrdered(diagram.getRootGroup());
            for (Entity g2 : groups) {
                if (!g2.isAutarkic()) continue;
                IEntityImage img = this.computeImage(g2);
                g2.overrideImage(img, g2.getGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                changed = true;
            }
        } while (changed);
    }

    private Collection<Entity> getOrdered(Entity root) {
        LinkedHashSet<Entity> ordered = new LinkedHashSet<Entity>();
        ordered.add(root);
        int size = 1;
        do {
            size = ordered.size();
            this.addOneLevel(ordered);
        } while (size != ordered.size());
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity g2 : ordered) {
            if (g2.isRoot()) continue;
            result.add(0, g2);
        }
        return result;
    }

    private void addOneLevel(Collection<Entity> currents) {
        for (Entity g2 : new ArrayList<Entity>(currents)) {
            for (Entity child : this.reverse(g2.groups())) {
                currents.add(child);
            }
        }
    }

    private List<Entity> reverse(Collection<Entity> source) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity g2 : source) {
            result.add(0, g2);
        }
        return result;
    }

    private IEntityImage computeImage(Entity g2) throws IOException, InterruptedException {
        GroupMakerState maker = new GroupMakerState(this.diagram, g2, this.stringBounder);
        return maker.getImage();
    }
}

