/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.klimt.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.klimt.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomTree;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AtomWithMargin;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeTable;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class StripeTree
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTree tree;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.TREE, 0, '\u0000');

    public StripeTree(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        this.tree = new AtomTree(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.tree, 2.0, 2.0);
        this.analyzeAndAdd(line);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    public void analyzeAndAdd(String line) {
        List<String> lines = StripeTable.getWithNewlinesInternal(line);
        for (String s2 : lines) {
            StripeSimple cell = new StripeSimple(this.fontConfiguration, this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
            String text = s2.replaceFirst("^\\s*\\|_", "");
            int level = this.computeLevel(s2);
            cell.analyzeAndAdd(text);
            this.tree.addCell(StripeTable.asAtom(Collections.singletonList(cell), 0.0), level);
        }
    }

    private int computeLevel(String s2) {
        int result = 1;
        while (s2.length() > 0) {
            if (s2.startsWith("  ")) {
                ++result;
                s2 = s2.substring(2);
                continue;
            }
            if (s2.startsWith("\t")) {
                ++result;
                s2 = s2.substring(1);
                continue;
            }
            return result;
        }
        return result;
    }
}

