/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.FontChange;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.HtmlCommand;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Img;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.PlainText;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Splitter;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.SpriteCommand;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.TextLink;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.Line;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TileText;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.SpriteContainer;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class SingleLine
extends AbstractTextBlock
implements Line {
    private final List<TextBlock> blocs = new ArrayList<TextBlock>();
    private final HorizontalAlignment horizontalAlignment;

    public static SingleLine withSomeHtmlTag(String text, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        SingleLine result = new SingleLine(horizontalAlignment);
        if (text.length() == 0) {
            text = " ";
        }
        Splitter lineSplitter = new Splitter(text);
        for (HtmlCommand cmd : lineSplitter.getHtmlCommands(false)) {
            String s2;
            if (cmd instanceof PlainText) {
                s2 = ((PlainText)cmd).getText();
                result.blocs.add(new TileText(s2, fontConfiguration, null));
                continue;
            }
            if (cmd instanceof TextLink) {
                s2 = ((TextLink)cmd).getText();
                Url url = ((TextLink)cmd).getUrl();
                result.blocs.add(new TileText(s2, fontConfiguration, url));
                continue;
            }
            if (cmd instanceof Img) {
                result.blocs.add(((Img)cmd).createMonoImage());
                continue;
            }
            if (cmd instanceof SpriteCommand) {
                Sprite sprite = spriteContainer.getSprite(((SpriteCommand)cmd).getSprite());
                if (sprite == null) continue;
                result.blocs.add(sprite.asTextBlock(fontConfiguration.getColor(), 1.0));
                continue;
            }
            if (!(cmd instanceof FontChange)) continue;
            fontConfiguration = ((FontChange)cmd).apply(fontConfiguration);
        }
        return result;
    }

    public static SingleLine rawText(String text, FontConfiguration fontConfiguration) {
        SingleLine result = new SingleLine(HorizontalAlignment.LEFT);
        if (text.length() == 0) {
            text = " ";
        }
        result.blocs.add(new TileText(text, fontConfiguration, null));
        return result;
    }

    private SingleLine(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (TextBlock b : this.blocs) {
            XDimension2D size2D = b.calculateDimension(stringBounder);
            width += size2D.getWidth();
            height = Math.max(height, size2D.getHeight());
        }
        return new XDimension2D(width, height);
    }

    private double maxDeltaY(UGraphic ug) {
        double result = 0.0;
        XDimension2D dim = this.calculateDimension(ug.getStringBounder());
        for (TextBlock b : this.blocs) {
            if (!(b instanceof TileText)) continue;
            XDimension2D dimBloc = b.calculateDimension(ug.getStringBounder());
            double deltaY = dim.getHeight() - dimBloc.getHeight() + ((TileText)b).getFontSize2D();
            result = Math.max(result, deltaY);
        }
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        double deltaY = this.maxDeltaY(ug);
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        double x = 0.0;
        for (TextBlock b : this.blocs) {
            if (b instanceof TileText) {
                b.drawU(ug.apply(new UTranslate(x, deltaY)));
            } else {
                double dy = dim.getHeight() - b.calculateDimension(stringBounder).getHeight();
                b.drawU(ug.apply(new UTranslate(x, dy)));
            }
            x += b.calculateDimension(stringBounder).getWidth();
        }
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }
}

