/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.svek.GuideLine;

public class TextBlockArrow2
extends AbstractTextBlock
implements TextBlock {
    private final double size;
    private final GuideLine angle;
    private final HColor color;

    public TextBlockArrow2(GuideLine angle, FontConfiguration fontConfiguration) {
        this.angle = Objects.requireNonNull(angle);
        this.size = fontConfiguration.getFont().getSize2D();
        this.color = fontConfiguration.getColor();
    }

    @Override
    public void drawU(UGraphic ug) {
        int triSize = (int)(this.size * 0.8);
        ug = ug.apply(this.color);
        ug = ug.apply(this.color.bg());
        ug = ug.apply(new UTranslate(triSize / 2, this.size / 2.0));
        UPolygon triangle = new UPolygon();
        double beta = 2.5132741228718345;
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2()));
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2() + 2.5132741228718345));
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2() - 2.5132741228718345));
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2()));
        ug.draw(triangle);
    }

    private XPoint2D getPoint(double len, double alpha) {
        double dx = len * Math.sin(alpha);
        double dy = len * Math.cos(alpha);
        return new XPoint2D(dx, dy);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.size, this.size);
    }
}

