/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.sprite;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.version.Version;

public class ResourcesUtils {
    public static Set<String> getJarFile(String path, boolean folder) throws IOException {
        if (path.startsWith("/") || path.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        String protocol = ResourcesUtils.getProtocol();
        if ("file".equals(protocol)) {
            URL local = Version.class.getClassLoader().getResource(path);
            try {
                return ResourcesUtils.listEntry(new SFile(local.toURI()));
            }
            catch (URISyntaxException e) {
                Logme.error(e);
                return null;
            }
        }
        if ("jar".equals(protocol)) {
            String classFile = Version.class.getName().replace(".", "/") + ".class";
            URL versionURL = Version.class.getClassLoader().getResource(classFile);
            String jarPath = versionURL.getPath().substring(5, versionURL.getPath().indexOf("!"));
            if (folder) {
                return ResourcesUtils.listFolders(new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name())), path + "/");
            }
            return ResourcesUtils.listFiles(new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name())), path + "/");
        }
        return Collections.emptySet();
    }

    private static String getProtocol() {
        URL resource = Version.class.getClassLoader().getResource("znaishaded/net/sourceforge/plantuml/version/logo.png");
        return resource.getProtocol();
    }

    private static Set<String> listFiles(JarFile jarFile, String path) {
        Enumeration<JarEntry> entries = jarFile.entries();
        TreeSet<String> result = new TreeSet<String>();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith(path)) continue;
            result.add(name.substring(path.length()));
        }
        return result;
    }

    private static Set<String> listFolders(JarFile jarFile, String path) {
        Enumeration<JarEntry> entries = jarFile.entries();
        TreeSet<String> result = new TreeSet<String>();
        while (entries.hasMoreElements()) {
            String folder;
            int x;
            String name = entries.nextElement().getName();
            if (!name.startsWith(path) || (x = (folder = name.substring(path.length())).indexOf(47)) == -1) continue;
            result.add(folder.substring(0, x));
        }
        return result;
    }

    private static Set<String> listEntry(SFile dir) {
        TreeSet<String> result = new TreeSet<String>();
        for (String n : dir.list()) {
            result.add(n);
        }
        return result;
    }
}

