/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.mda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.SourceStringReader;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.EntityFactory;
import znaishaded.net.sourceforge.plantuml.api.mda.option2.MDADiagram;
import znaishaded.net.sourceforge.plantuml.api.mda.option2.MDAPackage;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.mda.MDAPackageImpl;

public class MDADiagramImpl
implements MDADiagram {
    private final Collection<MDAPackage> packages = new ArrayList<MDAPackage>();

    public static MDADiagram create(String uml) {
        List<BlockUml> blocks = new SourceStringReader(uml).getBlocks();
        if (blocks.size() == 0 && (blocks = new SourceStringReader(uml = "@startuml\n" + uml + "\n@enduml").getBlocks()).size() == 0) {
            return null;
        }
        BlockUml block = blocks.get(0);
        Diagram diagram = block.getDiagram();
        if (diagram instanceof ClassDiagram) {
            return new MDADiagramImpl((ClassDiagram)diagram);
        }
        return null;
    }

    private MDADiagramImpl(ClassDiagram classDiagram) {
        EntityFactory entityFactory = classDiagram.getEntityFactory();
        this.packages.add(new MDAPackageImpl(entityFactory.getRootGroup()));
        for (Entity group : entityFactory.groups()) {
            this.packages.add(new MDAPackageImpl(group));
        }
    }

    @Override
    public Collection<MDAPackage> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }
}

