/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class ElementMenuEntry
extends AbstractElement {
    private final TextBlock block;
    private final String text;
    private HColor background;
    private double xxx;

    public ElementMenuEntry(String text, UFont font, ISkinSimple spriteContainer) {
        FontConfiguration config = FontConfiguration.blackBlueTrue(font);
        this.block = Display.create(text).create(config, HorizontalAlignment.LEFT, spriteContainer);
        this.text = text;
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        if (this.text.equals("-")) {
            return new XDimension2D(10.0, 5.0);
        }
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        ug = ug.apply(this.getBlack());
        if (this.background != null) {
            XDimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
            ug.apply(this.background.bg()).draw(URectangle.build(dim.getWidth(), dim.getHeight()));
        }
        this.block.drawU(ug);
    }

    public double getX() {
        return this.xxx;
    }

    public void setX(double x) {
        this.xxx = x;
    }

    public String getText() {
        return this.text;
    }

    public HColor getBackground() {
        return this.background;
    }

    public void setBackground(HColor background) {
        this.background = background;
    }
}

