/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.iterator.CodeIterator;
import znaishaded.net.sourceforge.plantuml.tim.iterator.CodePosition;

public class CodeIteratorImpl
implements CodeIterator {
    private final List<StringLocated> list;
    private int current = 0;
    private int countJump = 0;

    public CodeIteratorImpl(List<StringLocated> list) {
        this.list = list;
    }

    @Override
    public StringLocated peek() {
        if (this.current == this.list.size()) {
            return null;
        }
        if (this.current > this.list.size()) {
            throw new IllegalStateException();
        }
        return this.list.get(this.current);
    }

    @Override
    public void next() {
        if (this.current >= this.list.size()) {
            throw new IllegalStateException();
        }
        assert (this.current < this.list.size());
        ++this.current;
        assert (this.current <= this.list.size());
    }

    @Override
    public CodePosition getCodePosition() {
        return new Position(this.current);
    }

    @Override
    public void jumpToCodePosition(CodePosition newPosition) throws EaterException {
        ++this.countJump;
        if (this.countJump > 999) {
            throw EaterException.unlocated("Infinite loop?");
        }
        Position pos = (Position)newPosition;
        this.current = pos.pos;
    }

    static class Position
    implements CodePosition {
        final int pos;

        Position(int pos) {
            this.pos = pos;
        }
    }
}

