/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.text.TLineType;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.FunctionsSet;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import znaishaded.net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorLegacyDefine
extends AbstractCodeIterator {
    private final FunctionsSet functionsSet;
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorLegacyDefine(CodeIterator source, TContext context, TMemory memory, FunctionsSet functionsSet, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.functionsSet = functionsSet;
        this.logs = logs;
        this.memory = memory;
    }

    @Override
    public StringLocated peek() throws EaterException, EaterExceptionLocated {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            if (result.getType() == TLineType.LEGACY_DEFINE) {
                this.logs.add(result);
                this.functionsSet.executeLegacyDefine(this.context, this.memory, result);
                this.next();
                continue;
            }
            if (result.getType() != TLineType.LEGACY_DEFINELONG) break;
            this.logs.add(result);
            this.functionsSet.executeLegacyDefineLong(this.context, this.memory, result);
            this.next();
        }
        return result;
    }
}

