/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wire;

import znaishaded.net.sourceforge.plantuml.klimt.UChange;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class WPrint {
    private final UTranslate position;
    private final HColor color;
    private final Display label;
    private final ISkinParam skinParam;

    public WPrint(ISkinParam skinParam, UTranslate position, HColor color, Display label) {
        this.position = position;
        this.skinParam = skinParam;
        this.label = label;
        this.color = color == null ? this.getBlack() : color;
    }

    private HColor getBlack() {
        return HColors.BLACK.withDark(HColors.WHITE);
    }

    private TextBlock getTextBlock() {
        FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.sansSerif(10)).changeColor(this.color);
        return this.label.create(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
    }

    public UChange getPosition() {
        return this.position;
    }

    public void drawMe(UGraphic ug) {
        this.getTextBlock().drawU(ug);
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getTextBlock().calculateDimension(stringBounder).getHeight();
    }
}

