/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.xmi;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.xmi.XmiSequenceDiagram;

public class XmiSequenceDiagramArgo
extends XmiSequenceDiagram {
    public XmiSequenceDiagramArgo(SequenceDiagram diagram, Document document) {
        super(diagram, document);
    }

    @Override
    public void build() {
        Element xmi = this.document.createElement("XMI");
        xmi.setAttribute("xmi.version", "1.2");
        xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(xmi);
        Element header = this.document.createElement("XMI.header");
        xmi.appendChild(header);
        Element metamodel = this.document.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.4");
        header.appendChild(metamodel);
        Element content = this.document.createElement("XMI.content");
        xmi.appendChild(content);
        Element model = this.createElement(this.diagram, "UML:Model");
        model.setAttribute("name", "PlantUML");
        content.appendChild(model);
        Element ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        model.appendChild(ownedElement);
        ownedElement.appendChild(this.createCollaborationElement());
        for (Participant participant : this.diagram.participants()) {
            ownedElement.appendChild(this.createActorElement(participant));
        }
    }

    private Element createActorElement(Participant participant) {
        Element actor = this.createElement(participant, "UML:Actor");
        actor.setAttribute("name", String.join((CharSequence)" ", participant.getDisplay(false).asList()));
        return actor;
    }

    private Node createCollaborationElement() {
        Element collaboration = this.document.createElement("UML:Collaboration");
        Element ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        for (Participant participant : this.diagram.participants()) {
            ownedElement.appendChild(this.createClassifierRole(participant));
        }
        collaboration.appendChild(ownedElement);
        Node messages = collaboration.appendChild(this.document.createElement("UML:Collaboration.interaction")).appendChild(this.document.createElement("UML:Interaction")).appendChild(this.document.createElement("UML:Interaction.message"));
        Message prevMessage = null;
        for (Event event : this.diagram.events()) {
            if (!(event instanceof Message)) continue;
            Message message = (Message)event;
            messages.appendChild(this.createMessage(message, prevMessage));
            ownedElement.appendChild(this.createSendAction(message));
            prevMessage = message;
        }
        return collaboration;
    }

    private Node createSendAction(Message message) {
        Element sendAction = this.createElement(message, "UML:SendAction");
        sendAction.appendChild(this.document.createElement("UML:Action.script")).appendChild(this.createElement("UML:ActionExpression", new String[][]{{"xmi.id", this.getXmiId("UML:ActionExpression", message)}, {"body", this.getDisplayString(message.getLabel())}}));
        return sendAction;
    }

    private Element createElement(Object object, String tag) {
        return this.createElement(tag, new String[][]{{"xmi.id", this.getXmiId("UML:ActionExpression", object)}});
    }

    private Node createRef(String tag, Object target) {
        Element role = this.document.createElement(tag);
        role.setAttribute("xmi.idref", this.getXmiId(tag, target));
        return role;
    }

    private Element createClassifierRole(Participant participant) {
        Element classifierRole = this.createElement(participant, "UML:ClassifierRole");
        classifierRole.setAttribute("name", participant.getCode());
        classifierRole.appendChild(this.document.createElement("UML:ClassifierRole.base")).appendChild(this.createRef("UML:Actor", participant));
        return classifierRole;
    }

    private Element createMessage(Message message, Message prevMessage) {
        Element messageElement = this.createElement(message, "UML:Message");
        messageElement.appendChild(this.document.createElement("UML:Message.sender")).appendChild(this.createRef("UML:ClassifierRole", message.getParticipant1()));
        messageElement.appendChild(this.document.createElement("UML:Message.receiver")).appendChild(this.createRef("UML:ClassifierRole", message.getParticipant2()));
        messageElement.appendChild(this.document.createElement("UML:Message.action")).appendChild(this.createRef("UML:SendAction", message));
        if (prevMessage != null) {
            messageElement.appendChild(this.document.createElement("UML:Message.predecessor")).appendChild(this.createRef("UML:Message", prevMessage));
        }
        return messageElement;
    }
}

