/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.org.apache.ant.compress.resources.CpioFileSet;
import znaishaded.org.apache.ant.compress.taskdefs.ArchiveBase;
import znaishaded.org.apache.ant.compress.util.CpioStreamFactory;
import znaishaded.org.apache.commons.compress.archivers.ArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import znaishaded.org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.types.ArchiveFileSet;
import znaishaded.org.apache.tools.ant.types.EnumeratedAttribute;
import znaishaded.org.apache.tools.ant.types.Resource;

public class Cpio
extends ArchiveBase {
    private Format format = Format.BINARY;
    private int blockSize = 512;

    public Cpio() {
        this.setFactory(new CpioStreamFactory(){

            @Override
            public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
                return new CpioArchiveOutputStream(stream, Cpio.this.format.getFormat(), Cpio.this.blockSize, encoding);
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            @Override
            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                int mode;
                boolean isDir = r.getResource().isDirectory();
                CpioArchiveEntry ent = new CpioArchiveEntry(Cpio.this.format.getFormat(), r.getName(), isDir ? 0L : r.getResource().getSize());
                ent.setTime(Cpio.this.round(r.getResource().getLastModified(), 1000L) / 1000L);
                int n = mode = isDir ? 16877 : 33188;
                if (!isDir && r.getCollectionFlags().hasModeBeenSet()) {
                    ent.setMode(r.getCollectionFlags().getMode());
                } else if (isDir && r.getCollectionFlags().hasDirModeBeenSet()) {
                    ent.setMode(r.getCollectionFlags().getDirMode());
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    ent.setMode(r.getResourceFlags().getMode());
                } else {
                    ent.setMode(mode);
                }
                if (r.getResourceFlags().hasUserIdBeenSet()) {
                    ent.setUID(r.getResourceFlags().getUserId());
                } else if (r.getCollectionFlags().hasUserIdBeenSet()) {
                    ent.setUID(r.getCollectionFlags().getUserId());
                }
                if (r.getResourceFlags().hasGroupIdBeenSet()) {
                    ent.setGID(r.getResourceFlags().getGroupId());
                } else if (r.getCollectionFlags().hasGroupIdBeenSet()) {
                    ent.setGID(r.getCollectionFlags().getGroupId());
                }
                return ent;
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            @Override
            public ArchiveFileSet buildFileSet(Resource dest) {
                CpioFileSet afs = new CpioFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setFormat(Format f) {
        this.format = f;
    }

    public void setBlockSize(int size) {
        if (size <= 0) {
            throw new BuildException("Block size must be a positive number");
        }
        this.blockSize = size;
    }

    public static class Format
    extends EnumeratedAttribute {
        private static final String BINARY_NAME = "binary";
        private static final String OLD_ASCII_NAME = "old-ascii";
        private static final String ODC_NAME = "odc";
        private static final String NEW_ASCII_NAME = "new-ascii";
        private static final String CRC_NAME = "crc";
        public static final Format BINARY = new Format("binary");
        public static final Format OLD_ASCII = new Format("old-ascii");
        public static final Format ODC = new Format("odc");
        public static final Format NEW_ASCII = new Format("new-ascii");

        public Format(String v) {
            this.setValue(v);
        }

        public Format() {
            this.setValue(BINARY_NAME);
        }

        @Override
        public String[] getValues() {
            return new String[]{BINARY_NAME, OLD_ASCII_NAME, ODC_NAME, NEW_ASCII_NAME};
        }

        public short getFormat() {
            String v = this.getValue();
            if (v.equals(OLD_ASCII_NAME) || v.equals(ODC_NAME)) {
                return 4;
            }
            if (v.equals(NEW_ASCII_NAME)) {
                return 1;
            }
            if (v.equals(CRC_NAME)) {
                return 2;
            }
            return 8;
        }

        public boolean equals(Object other) {
            return other instanceof Format && ((Format)other).getFormat() == this.getFormat();
        }
    }
}

