/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal.inline;

import znaishaded.org.commonmark.node.Image;
import znaishaded.org.commonmark.node.Link;
import znaishaded.org.commonmark.node.LinkReferenceDefinition;
import znaishaded.org.commonmark.parser.InlineParserContext;
import znaishaded.org.commonmark.parser.beta.LinkInfo;
import znaishaded.org.commonmark.parser.beta.LinkProcessor;
import znaishaded.org.commonmark.parser.beta.LinkResult;
import znaishaded.org.commonmark.parser.beta.Scanner;

public class CoreLinkProcessor
implements LinkProcessor {
    @Override
    public LinkResult process(LinkInfo linkInfo, Scanner scanner, InlineParserContext context) {
        if (linkInfo.destination() != null) {
            return CoreLinkProcessor.process(linkInfo, scanner, linkInfo.destination(), linkInfo.title());
        }
        String label = linkInfo.label();
        String ref = label != null && !label.isEmpty() ? label : linkInfo.text();
        LinkReferenceDefinition def = context.getDefinition(LinkReferenceDefinition.class, ref);
        if (def != null) {
            return CoreLinkProcessor.process(linkInfo, scanner, def.getDestination(), def.getTitle());
        }
        return LinkResult.none();
    }

    private static LinkResult process(LinkInfo linkInfo, Scanner scanner, String destination, String title) {
        if (linkInfo.marker() != null && linkInfo.marker().getLiteral().equals("!")) {
            return LinkResult.wrapTextIn(new Image(destination, title), scanner.position()).includeMarker();
        }
        return LinkResult.wrapTextIn(new Link(destination, title), scanner.position());
    }
}

