/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.renderer.markdown;

import java.io.IOException;
import java.util.LinkedList;
import znaishaded.org.commonmark.text.CharMatcher;

public class MarkdownWriter {
    private final Appendable buffer;
    private int blockSeparator = 0;
    private char lastChar;
    private boolean atLineStart = true;
    private final LinkedList<String> prefixes = new LinkedList();
    private final LinkedList<Boolean> tight = new LinkedList();
    private final LinkedList<CharMatcher> rawEscapes = new LinkedList();

    public MarkdownWriter(Appendable out) {
        this.buffer = out;
    }

    public void raw(String s2) {
        this.flushBlockSeparator();
        this.write(s2, null);
    }

    public void raw(char c) {
        this.flushBlockSeparator();
        this.write(c);
    }

    public void text(String s2, CharMatcher escape) {
        if (s2.isEmpty()) {
            return;
        }
        this.flushBlockSeparator();
        this.write(s2, escape);
        this.lastChar = s2.charAt(s2.length() - 1);
        this.atLineStart = false;
    }

    public void line() {
        this.write('\n');
        this.writePrefixes();
        this.atLineStart = true;
    }

    public void block() {
        this.blockSeparator = this.isTight() ? 1 : 2;
        this.atLineStart = true;
    }

    public void pushPrefix(String prefix) {
        this.prefixes.addLast(prefix);
    }

    public void writePrefix(String prefix) {
        boolean tmp = this.atLineStart;
        this.raw(prefix);
        this.atLineStart = tmp;
    }

    public void popPrefix() {
        this.prefixes.removeLast();
    }

    public void pushTight(boolean tight) {
        this.tight.addLast(tight);
    }

    public void popTight() {
        this.tight.removeLast();
    }

    public void pushRawEscape(CharMatcher rawEscape) {
        this.rawEscapes.add(rawEscape);
    }

    public void popRawEscape() {
        this.rawEscapes.removeLast();
    }

    public char getLastChar() {
        return this.lastChar;
    }

    public boolean isAtLineStart() {
        return this.atLineStart;
    }

    private void write(String s2, CharMatcher escape) {
        int length;
        try {
            if (this.rawEscapes.isEmpty() && escape == null) {
                this.buffer.append(s2);
            } else {
                for (int i = 0; i < s2.length(); ++i) {
                    this.append(s2.charAt(i), escape);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if ((length = s2.length()) != 0) {
            this.lastChar = s2.charAt(length - 1);
        }
        this.atLineStart = false;
    }

    private void write(char c) {
        try {
            this.append(c, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastChar = c;
        this.atLineStart = false;
    }

    private void writePrefixes() {
        if (!this.prefixes.isEmpty()) {
            for (String prefix : this.prefixes) {
                this.write(prefix, null);
            }
        }
    }

    private void flushBlockSeparator() {
        if (this.blockSeparator != 0) {
            this.write('\n');
            this.writePrefixes();
            if (this.blockSeparator > 1) {
                this.write('\n');
                this.writePrefixes();
            }
            this.blockSeparator = 0;
        }
    }

    private void append(char c, CharMatcher escape) throws IOException {
        if (this.needsEscaping(c, escape)) {
            if (c == '\n') {
                this.buffer.append("&#10;");
            } else {
                this.buffer.append('\\');
                this.buffer.append(c);
            }
        } else {
            this.buffer.append(c);
        }
    }

    private boolean isTight() {
        return !this.tight.isEmpty() && this.tight.getLast() != false;
    }

    private boolean needsEscaping(char c, CharMatcher escape) {
        return escape != null && escape.matches(c) || this.rawNeedsEscaping(c);
    }

    private boolean rawNeedsEscaping(char c) {
        for (CharMatcher rawEscape : this.rawEscapes) {
            if (!rawEscape.matches(c)) continue;
            return true;
        }
        return false;
    }
}

