/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.text;

public class Characters {
    public static int find(char c, CharSequence s2, int startIndex) {
        int length = s2.length();
        for (int i = startIndex; i < length; ++i) {
            if (s2.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int findLineBreak(CharSequence s2, int startIndex) {
        int length = s2.length();
        for (int i = startIndex; i < length; ++i) {
            switch (s2.charAt(i)) {
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence s2) {
        return Characters.skipSpaceTab(s2, 0, s2.length()) == s2.length();
    }

    public static boolean hasNonSpace(CharSequence s2) {
        int length = s2.length();
        int skipped = Characters.skip(' ', s2, 0, length);
        return skipped != length;
    }

    public static boolean isLetter(CharSequence s2, int index) {
        int codePoint = Character.codePointAt(s2, index);
        return Character.isLetter(codePoint);
    }

    public static boolean isSpaceOrTab(CharSequence s2, int index) {
        if (index < s2.length()) {
            switch (s2.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPunctuationCodePoint(int codePoint) {
        switch (Character.getType(codePoint)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        switch (codePoint) {
            case 36: 
            case 43: 
            case 60: 
            case 61: 
            case 62: 
            case 94: 
            case 96: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespaceCodePoint(int codePoint) {
        switch (codePoint) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return Character.getType(codePoint) == 12;
    }

    public static int skip(char skip, CharSequence s2, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            if (s2.charAt(i) == skip) continue;
            return i;
        }
        return endIndex;
    }

    public static int skipBackwards(char skip, CharSequence s2, int startIndex, int lastIndex) {
        for (int i = startIndex; i >= lastIndex; --i) {
            if (s2.charAt(i) == skip) continue;
            return i;
        }
        return lastIndex - 1;
    }

    public static int skipSpaceTab(CharSequence s2, int startIndex, int endIndex) {
        block3: for (int i = startIndex; i < endIndex; ++i) {
            switch (s2.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return endIndex;
    }

    public static int skipSpaceTabBackwards(CharSequence s2, int startIndex, int lastIndex) {
        block3: for (int i = startIndex; i >= lastIndex; --i) {
            switch (s2.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return lastIndex - 1;
    }
}

