/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescriptionParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMemberParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenParameterList;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DoxygenCompoundParser {
    private final ComponentsRegistry componentsRegistry;
    private final String content;
    private final String id;
    private final DoxygenCompound compound;

    private DoxygenCompoundParser(ComponentsRegistry componentsRegistry, String content, String id) {
        this.componentsRegistry = componentsRegistry;
        this.content = content;
        this.id = id;
        this.compound = new DoxygenCompound();
    }

    public static DoxygenCompound parse(ComponentsRegistry componentsRegistry, String content, String id) {
        DoxygenCompoundParser parser = new DoxygenCompoundParser(componentsRegistry, content, id);
        parser.parseXml();
        return parser.compound;
    }

    private void parseXml() {
        Document document = XmlUtils.parseXml(this.content);
        Node root = XmlUtils.anyNestedNodeByName(document, "doxygen");
        Node compoundRoot = XmlUtils.allNestedNodesStreamByName(root, "compounddef").filter(node -> this.id.equals(XmlUtils.getAttributeText(node, "id"))).findFirst().orElseThrow(() -> new IllegalArgumentException("can't find compound with id: " + this.id));
        this.compound.setId(XmlUtils.getAttributeText(compoundRoot, "id"));
        this.compound.setKind(XmlUtils.getAttributeText(compoundRoot, "kind"));
        this.compound.setName(XmlUtils.nextLevelNodeByName(compoundRoot, "compoundname").getTextContent());
        this.compound.setDescription(new DoxygenDescription(DoxygenDescriptionParser.parseBrief(this.componentsRegistry, XmlUtils.nextLevelNodeByName(compoundRoot, "briefdescription")), DoxygenDescriptionParser.parseFull(this.componentsRegistry, new DoxygenParameterList(), this.id, XmlUtils.nextLevelNodeByName(compoundRoot, "detaileddescription"))));
        XmlUtils.allNestedNodesStreamByName(compoundRoot, "memberdef").forEach(this::parseMember);
    }

    private void parseMember(Node memberNode) {
        DoxygenMember doxygenMember = DoxygenMemberParser.parse(this.componentsRegistry, memberNode);
        doxygenMember.setCompound(this.compound);
        this.compound.addMember(doxygenMember);
    }
}

