/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.plugin;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.Doxygen;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMembersList;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenMemberListExtractor;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class DoxygenDocParamsIncludePlugin
implements IncludePlugin {
    private DoxygenMembersList membersList;

    @Override
    public String id() {
        return "doxygen-doc-params";
    }

    @Override
    public IncludePlugin create() {
        return DoxygenDocParamsIncludePlugin.createDocParamsPlugin();
    }

    public static IncludePlugin createDocParamsPlugin() {
        return new DoxygenDocParamsIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ApiParameters apiParameters;
        Doxygen doxygen = Doxygen.INSTANCE;
        String fullName = pluginParams.getFreeParam();
        this.membersList = DoxygenMemberListExtractor.extract(doxygen, componentsRegistry, pluginParams.getOpts(), false, fullName);
        if (this.membersList.isEmpty()) {
            DoxygenMemberListExtractor.throwIfMembersListIsEmpty(doxygen, componentsRegistry, fullName);
        }
        DoxygenDescription description = this.membersList.first().getDescription();
        String type = pluginParams.getOpts().get("type", "");
        ApiParameters apiParameters2 = apiParameters = "template".equals(type) ? description.getFull().getApiTemplateParameters() : description.getFull().getApiParameters();
        if (apiParameters == null) {
            return PluginResult.empty();
        }
        Map<String, Object> props = pluginParams.getOpts().toMap();
        props.putAll(apiParameters.toMap());
        props.putAll(pluginParams.getOpts().toMap());
        return PluginResult.docElement("ApiParameters", props);
    }

    @Override
    public SearchText textForSearch() {
        ApiParameters apiParameters = this.membersList.first().getDescription().getFull().getApiParameters();
        if (apiParameters != null) {
            return SearchScore.HIGH.text(apiParameters.combinedTextForSearch());
        }
        return null;
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(Doxygen.INSTANCE.getIndexPath()));
    }
}

