/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.json;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetAutoTitleFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.json.JsonBasePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class JsonIncludePlugin
extends JsonBasePlugin
implements IncludePlugin {
    private String fileName;

    @Override
    public IncludePlugin create() {
        return new JsonIncludePlugin();
    }

    @Override
    protected void registerAdditionalParams(PluginParamsDefinition paramsDefinition) {
        paramsDefinition.add(SnippetAutoTitleFeature.paramsDefinition);
    }

    @Override
    protected Stream<PluginFeature> additionalPluginFeatures() {
        return Stream.of(new SnippetAutoTitleFeature(this.fileName));
    }

    @Override
    protected Stream<AuxiliaryFile> additionalAuxiliaryFiles() {
        return Stream.of(AuxiliaryFile.builtTime(this.resourcesResolver.fullPath(this.fileName)));
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fileName = pluginParams.getFreeParam();
        String json = componentsRegistry.resourceResolver().textContent(this.fileName);
        return this.commonProcess(componentsRegistry, markupPath, pluginParams, json);
    }

    @Override
    public String markdownRepresentation() {
        if (this.resourcesResolver == null) {
            return "";
        }
        String json = this.resourcesResolver.textContent(this.fileName);
        StringBuilder markdown = new StringBuilder();
        markdown.append("```json\n");
        markdown.append(json);
        if (!json.endsWith("\n")) {
            markdown.append("\n");
        }
        markdown.append("```");
        return markdown.toString();
    }
}

