/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.testingisdocumenting.znai.console.ConsoleOutput;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.console.ansi.FontStyle;
import org.testingisdocumenting.znai.server.sockets.JsonWebSocketHandler;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class PreviewUpdatePathWebSocketHandler
extends JsonWebSocketHandler
implements ConsoleOutput {
    private static final String URL = "/_preview-update";

    public PreviewUpdatePathWebSocketHandler(Consumer<Path> onPathReceived) {
        super("preview path change", URL, message -> {
            Map deserialize = (Map)JsonUtils.deserialize(message);
            Path newPath = Paths.get(deserialize.get("srcRoot").toString(), new String[0]);
            onPathReceived.accept(newPath);
        });
    }

    public void sendCompletion() {
        this.send(URL, Collections.singletonMap("type", "done"));
    }

    @Override
    public void out(Object ... styleOrValues) {
        this.send(URL, this.convertToJson("out", styleOrValues));
    }

    @Override
    public void err(Object ... styleOrValues) {
        this.send(URL, this.convertToJson("err", styleOrValues));
    }

    private Map<String, Object> convertToJson(String type, Object ... styleOrValue) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("type", type);
        result.put("parts", Arrays.stream(styleOrValue).map(this::convertPartToJson).toList());
        return result;
    }

    private Map<String, String> convertPartToJson(Object styleOrValue) {
        if (styleOrValue == null) {
            return this.typeAndValue("text", "null");
        }
        if (styleOrValue instanceof Color) {
            Color color = (Color)((Object)styleOrValue);
            return this.typeAndValue("color", color.name());
        }
        if (styleOrValue instanceof FontStyle) {
            FontStyle fontStyle = (FontStyle)((Object)styleOrValue);
            return this.typeAndValue("font", fontStyle.name());
        }
        return this.typeAndValue("text", styleOrValue.toString());
    }

    private Map<String, String> typeAndValue(String type, String value) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("type", type);
        result.put("value", value);
        return result;
    }

    @Override
    public void onConnect(String uri) {
    }
}

