/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.Arrays;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocNameAndOpts;

public class PlainTextTocPatcher {
    private final TableOfContents toc;

    public PlainTextTocPatcher(TableOfContents toc) {
        this.toc = toc;
    }

    public void patch(String patchInstructions) {
        Arrays.stream(patchInstructions.split("\n")).map(String::trim).forEach(this::apply);
    }

    private void apply(String instruction) {
        String[] commandAndArgs = instruction.split("\\s+");
        if (commandAndArgs.length < 2) {
            throw new IllegalArgumentException("wrong patch file format. \nexpect: command arg1 [arg2]\nreceived: " + instruction);
        }
        String command = commandAndArgs[0];
        DirNameFileName arg1 = new DirNameFileName(commandAndArgs[1]);
        DirNameFileName arg2 = new DirNameFileName(commandAndArgs.length > 2 ? commandAndArgs[2] : null);
        this.apply(command, arg1, arg2);
    }

    private void apply(String command, DirNameFileName arg1, DirNameFileName arg2) {
        TocNameAndOpts chapter1 = new TocNameAndOpts(arg1.dirName);
        TocNameAndOpts page1 = new TocNameAndOpts(arg1.fileName);
        TocNameAndOpts chapter2 = new TocNameAndOpts(arg2.dirName);
        TocNameAndOpts page2 = new TocNameAndOpts(arg2.fileName);
        switch (command) {
            case "remove": {
                this.toc.removeTocItem(arg1.dirName, arg1.fileName);
                break;
            }
            case "add": {
                this.toc.addTocItem(chapter1, page1);
                break;
            }
            case "replace": {
                this.toc.replaceTocItem(arg1.dirName, arg1.fileName, chapter2, page2);
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized command: " + command);
            }
        }
    }

    private static class DirNameFileName {
        final String dirName;
        final String fileName;

        DirNameFileName(String arg) {
            if (arg == null) {
                this.dirName = "";
                this.fileName = "";
                return;
            }
            String[] dirNameFileName = arg.split("/");
            if (dirNameFileName.length != 2) {
                throw new IllegalArgumentException("wrong command argument.\nexpect: dir-name/file-name\nreceived: " + arg);
            }
            this.dirName = dirNameFileName[0];
            this.fileName = dirNameFileName[1];
        }
    }
}

