/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.processors;

import java.util.Map;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.headers.Header;
import znaishaded.io.swagger.v3.oas.models.links.Link;
import znaishaded.io.swagger.v3.parser.ResolverCache;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.processors.HeaderProcessor;
import znaishaded.io.swagger.v3.parser.util.RefUtils;

public class LinkProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final HeaderProcessor headerProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public LinkProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public LinkProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.headerProcessor = new HeaderProcessor(cache, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processLink(Link link) {
        if (link.get$ref() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(link.get$ref());
            String $ref = link.get$ref();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalLink($ref, refFormat)) != null) {
                link.set$ref(newRef);
            }
        } else if (link.getHeaders() != null) {
            Map<String, Header> headers = link.getHeaders();
            for (String headerName : headers.keySet()) {
                Header header = headers.get(headerName);
                this.headerProcessor.processHeader(header);
            }
        }
    }
}

