/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import znaishaded.com.plantuml.api.cheerpj.WasmLog;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.DefinitionsContainer;
import znaishaded.net.sourceforge.plantuml.file.AParentFolderRegular;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;
import znaishaded.net.sourceforge.plantuml.preproc.ImportedFiles;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineNumbered;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineReader;
import znaishaded.net.sourceforge.plantuml.preproc.UncommentReadLine;
import znaishaded.net.sourceforge.plantuml.preproc2.Preprocessor;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.utils.CharsetUtils;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;

public final class BlockUmlBuilder
implements DefinitionsContainer {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<FileWithSuffix> usedFiles = new HashSet<FileWithSuffix>();
    private final UncommentReadLine reader;
    private final Defines defines;
    private final ImportedFiles importedFiles;
    private final Charset charset;

    @Deprecated
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader readerInit, SFile newCurrentDir, String desc) throws IOException {
        this(config, CharsetUtils.charsetOrDefault(charset), defines, readerInit, newCurrentDir, desc);
    }

    @Deprecated
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader) throws IOException {
        this(config, charset, defines, reader, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> config, Charset charset, Defines defines, Reader readerInit, SFile newCurrentDir, String desc) throws IOException {
        this.defines = defines;
        this.charset = Objects.requireNonNull(charset);
        this.reader = new UncommentReadLine(ReadLineReader.create(readerInit, desc));
        this.importedFiles = ImportedFiles.createImportedFiles(new AParentFolderRegular(newCurrentDir));
        try (Preprocessor includer = new Preprocessor(config, this.reader);){
            this.init(includer);
        }
        finally {
            readerInit.close();
        }
    }

    private void init(ReadLineNumbered includer) throws IOException {
        StringLocated s2 = null;
        ArrayList<StringLocated> current = null;
        boolean paused = false;
        while ((s2 = includer.readLine()) != null) {
            StringLocated append;
            if (StartUtils.isArobaseStartDiagram(s2.getString())) {
                current = new ArrayList<StringLocated>();
                paused = false;
            }
            if (StartUtils.isArobasePauseDiagram(s2.getString())) {
                paused = true;
                this.reader.setPaused(true);
            }
            if (StartUtils.isExit(s2.getString())) {
                paused = true;
                this.reader.setPaused(true);
            }
            if (current != null && !paused) {
                current.add(s2);
            } else if (paused && (append = StartUtils.getPossibleAppend(s2)) != null) {
                current.add(append);
            }
            if (StartUtils.isArobaseUnpauseDiagram(s2.getString())) {
                paused = false;
                this.reader.setPaused(false);
            }
            if (!StartUtils.isArobaseEndDiagram(s2.getString()) || current == null) continue;
            if (paused) {
                current.add(s2);
            }
            WasmLog.log("...text loaded...");
            BlockUml uml = new BlockUml(current, this.defines.cloneMe(), null, this, this.charset);
            this.usedFiles.addAll(uml.getIncluded());
            this.blocks.add(uml);
            current = null;
            this.reader.setPaused(false);
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }

    @Override
    public List<String> getDefinition(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            return block.getDefinition(false);
        }
        return Collections.emptyList();
    }

    @Override
    public final ImportedFiles getImportedFiles() {
        return this.importedFiles;
    }

    @Override
    @Deprecated
    public final String getCharset() {
        return this.charset.name();
    }
}

