/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram.command;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.GroupType;
import znaishaded.net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandPartition
extends SingleLineCommand2<ActivityDiagram> {
    public CommandPartition() {
        super(CommandPartition.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPartition.class.getName(), RegexLeaf.start(), new RegexLeaf("partition"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%g][^%g]+[%g]|\\S+)"), RegexLeaf.spaceZeroOrMore(), new RegexOr(CommandPartition.color().getRegex(), new RegexLeaf("LEGACYCOLORIGNORED", "(#[0-9a-fA-F]{6}|#?\\w+)?")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{?"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(arg.get("NAME", 0)));
        diagram.gotoGroup(quark, Display.getWithNewlines(quark.getName()), GroupType.PACKAGE);
        Entity p = diagram.getCurrentGroup();
        Colors colors = CommandPartition.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        if (!colors.isEmpty()) {
            p.setColors(colors);
        }
        if (arg.get("STEREOTYPE", 0) != null) {
            p.setStereotype(Stereotype.build(arg.get("STEREOTYPE", 0)));
        }
        return CommandExecutionResult.ok();
    }
}

