/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileBox;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithNoteOpale;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileWithNotes;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final Colors colors;
    private final LinkRendering inlinkRendering;
    private final BoxStyle style;
    private final Url url;
    private final Stereotype stereotype;

    @Override
    public boolean containsBreak() {
        return false;
    }

    public InstructionSimple(Display label, LinkRendering inlinkRendering, Swimlane swimlane, BoxStyle style, Url url, Colors colors, Stereotype stereotype) {
        super(swimlane);
        this.stereotype = stereotype;
        this.url = url;
        this.style = style;
        this.label = label;
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
        this.colors = Objects.requireNonNull(colors);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        GtileBox result = GtileBox.create(stringBounder, this.colors.mute(skinParam), this.label, this.getSwimlaneIn(), this.style, this.stereotype);
        if (this.hasNotes()) {
            Collection notes = this.getPositionedNotes();
            if (notes.size() == 0) {
                throw new UnsupportedOperationException("wip");
            }
            if (notes.size() > 0) {
                return new GtileWithNotes(result, notes, skinParam);
            }
            return new GtileWithNoteOpale(result, (PositionedNote)notes.iterator().next(), skinParam, false);
        }
        return result;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.activity(this.label, this.getSwimlaneIn(), this.style, this.colors, this.stereotype);
        if (this.url != null) {
            result = factory.addUrl(result, this.url);
        }
        result = this.eventuallyAddNote(factory, result, result.getSwimlaneIn(), VerticalAlignment.CENTER);
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public CommandExecutionResult add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

