/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.decoration.symbol;

import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.style.SName;

class USymbolCard
extends USymbol {
    USymbolCard() {
    }

    @Override
    public SName getSName() {
        return SName.card;
    }

    private void drawCard(UGraphic ug, double width, double height, double shadowing, double top, double roundCorner) {
        URectangle shape = URectangle.build(width, height).rounded(roundCorner);
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
        if (top != 0.0) {
            ug.apply(UTranslate.dy(top)).draw(ULine.hline(width));
        }
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 3.0, 3.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolCard.this.drawCard(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), 0.0, symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolCard.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCard.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                USymbolCard.this.drawCard(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), dimTitle.getHeight() + dimStereo.getHeight() + 4.0, symbolContext.getRoundCorner());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 2.0)));
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

