/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.GroupType;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbols;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateDomain
extends SingleLineCommand2<DescriptionDiagram> {
    public static final String DISPLAY_WITH_GENERIC = "[%g](.+?)(?:\\<(" + GenericRegexProducer.PATTERN + ")\\>)?[%g]";
    public static final String CODE = "[^%s{}%g<>]+";

    public CommandCreateDomain() {
        super(CommandCreateDomain.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateDomain.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(requirement|domain)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY", DISPLAY_WITH_GENERIC), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([a-zA-Z0-9]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("GROUP", "(\\{)?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String s2;
        Entity entity;
        String typeString = arg.get("TYPE", 0);
        String displayString = arg.getLazzy("DISPLAY", 0);
        String codeString = arg.getLazzy("CODE", 0);
        if (codeString == null) {
            codeString = displayString;
        }
        String stereotype = arg.get("STEREO", 0);
        GroupType type = typeString.equalsIgnoreCase("domain") ? GroupType.DOMAIN : GroupType.REQUIREMENT;
        LeafType type2 = typeString.equalsIgnoreCase("domain") ? LeafType.DOMAIN : LeafType.REQUIREMENT;
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(codeString));
        if (quark.getData() != null) {
            return CommandExecutionResult.error("Object already exists : " + codeString);
        }
        Display display = Display.getWithNewlines(displayString);
        String urlString = arg.get("URL", 0);
        String group = arg.get("GROUP", 0);
        if (group != null) {
            diagram.gotoGroup(quark, display, type);
            entity = diagram.getCurrentGroup();
        } else {
            entity = diagram.reallyCreateLeaf(quark, display, type2, null);
        }
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = arg.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2));
        if (typeString.equalsIgnoreCase("domain")) {
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Machine>>")) {
                typeString = "machine";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Causal>>")) {
                typeString = "causal";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Designed>>")) {
                typeString = "designed";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Lexical>>")) {
                typeString = "lexical";
            }
            if (stereotype != null && stereotype.equalsIgnoreCase("<<Biddable>>")) {
                typeString = "biddable";
            }
        }
        USymbol usymbol = USymbols.fromString(typeString, diagram.getSkinParam());
        entity.setUSymbol(usymbol);
        return CommandExecutionResult.ok();
    }
}

