/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram.command;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbols;
import znaishaded.net.sourceforge.plantuml.descdiagram.command.CommandCreateElementFull;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandCreateElementMultilines
extends CommandMultilines2<AbstractEntityDiagram> {
    private final int type;

    public CommandCreateElementMultilines(int type) {
        super(CommandCreateElementMultilines.getRegexConcat(type), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
        this.type = type;
    }

    @Override
    public String getPatternEnd() {
        if (this.type == 0) {
            return "^(.*)[%g]$";
        }
        if (this.type == 1) {
            return "^([^\\[\\]]*)\\]$";
        }
        throw new IllegalArgumentException();
    }

    private static RegexConcat getRegexConcat(int type) {
        if (type == 0) {
            return RegexConcat.build(CommandCreateElementMultilines.class.getName() + type, RegexLeaf.start(), new RegexLeaf("TYPE", "(person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout)[%s]+"), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("[%g]"), new RegexLeaf("DESC", "([^%g]*)"), RegexLeaf.end());
        }
        if (type == 1) {
            return RegexConcat.build(CommandCreateElementMultilines.class.getName() + type, RegexLeaf.start(), new RegexLeaf("TYPE", "(person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout)[%s]+"), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), new RegexLeaf("DESC", "(.*)"), RegexLeaf.end());
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        String urlString;
        USymbol usymbol;
        LeafType type;
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String symbol = StringUtils.goUpperCase(line0.get("TYPE", 0));
        if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase/")) {
            type = LeafType.USECASE_BUSINESS;
            usymbol = null;
        } else {
            usymbol = USymbols.fromString(symbol, diagram.getSkinParam().actorStyle(), diagram.getSkinParam().componentStyle(), diagram.getSkinParam().packageStyle());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
            type = LeafType.DESCRIPTION;
        }
        String idShort = line0.get("CODE", 0);
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        Display display = lines.toDisplay();
        String descStart = line0.get("DESC", 0);
        if (StringUtils.isNotEmpty(descStart)) {
            display = display.addFirst(descStart);
        }
        if (StringUtils.isNotEmpty(lineLast.get(0))) {
            display = display.add(lineLast.get(0));
        }
        String stereotype = line0.get("STEREO", 0);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(idShort));
        Entity result = quark.getData();
        if (quark.getData() == null) {
            result = diagram.reallyCreateLeaf(quark, display, type, usymbol);
        }
        if (CommandCreateElementFull.existsWithBadType3(diagram, quark, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + quark.getName() + ") is already defined");
        }
        result.setUSymbol(usymbol);
        if (stereotype != null) {
            result.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((urlString = line0.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            result.addUrl(url);
        }
        Colors colors = CommandCreateElementMultilines.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        result.setColors(colors);
        return CommandExecutionResult.ok();
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

