/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ebnf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.ebnf.ETile;
import znaishaded.net.sourceforge.plantuml.ebnf.EbnfEngine;
import znaishaded.net.sourceforge.plantuml.ebnf.EbnfExpression;
import znaishaded.net.sourceforge.plantuml.ebnf.TextBlockable;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;
import znaishaded.net.sourceforge.plantuml.utils.CharInspector;

public class PSystemEbnf
extends TitledDiagram {
    private final List<TextBlockable> expressions = new ArrayList<TextBlockable>();

    public PSystemEbnf(UmlSource source) {
        super(source, UmlDiagramType.EBNF, null);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(EBNF)");
    }

    public CommandExecutionResult addBlocLines(BlocLines blines, String commentAbove, String commentBelow) {
        boolean isCompact = this.getPragma().isDefine("compact");
        CharInspector it = blines.inspector();
        EbnfExpression tmp1 = EbnfExpression.create(it, isCompact, commentAbove, commentBelow);
        if (tmp1.isEmpty()) {
            return CommandExecutionResult.error("Unparsable expression");
        }
        this.expressions.add(tmp1);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addNote(final Display note, Colors colors) {
        this.expressions.add(new TextBlockable(){

            @Override
            public TextBlock getUDrawable(ISkinParam skinParam) {
                FloatingNote f = FloatingNote.create(note, skinParam, SName.ebnf);
                return TextBlockUtils.withMargin(f, 0.0, 0.0, 5.0, 15.0);
            }
        });
        return CommandExecutionResult.ok();
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    @Override
    protected TextBlock getTextBlock() {
        if (this.expressions.size() == 0) {
            Style style = ETile.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            FontConfiguration fc = style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
            TextBlock tmp = EbnfEngine.syntaxError(fc, this.getSkinParam());
            return TextBlockUtils.addBackcolor(tmp, null);
        }
        TextBlock result = this.expressions.get(0).getUDrawable(this.getSkinParam());
        for (int i = 1; i < this.expressions.size(); ++i) {
            result = TextBlockUtils.mergeTB(result, this.expressions.get(i).getUDrawable(this.getSkinParam()), HorizontalAlignment.LEFT);
        }
        return TextBlockUtils.addBackcolor(result, null);
    }
}

