/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.compress;

import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.compress.CompressionMode;
import znaishaded.net.sourceforge.plantuml.klimt.compress.PiecewiseAffineTransform;
import znaishaded.net.sourceforge.plantuml.klimt.compress.UGraphicCompressOnXorY;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMax;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;

public class PiecewiseAffineOnXorYBuilder
extends AbstractTextBlock {
    private final TextBlock textBlock;
    private final CompressionMode mode;
    private final PiecewiseAffineTransform piecewiseAffineTransform;
    private MinMax cachedMinMax;

    public static TextBlock build(CompressionMode mode, TextBlock textBlock, PiecewiseAffineTransform piecewiseAffineTransform) {
        return new PiecewiseAffineOnXorYBuilder(mode, textBlock, piecewiseAffineTransform);
    }

    private PiecewiseAffineOnXorYBuilder(CompressionMode mode, TextBlock textBlock, PiecewiseAffineTransform piecewiseAffineTransform) {
        this.textBlock = textBlock;
        this.mode = mode;
        this.piecewiseAffineTransform = piecewiseAffineTransform;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.textBlock.drawU(UGraphicCompressOnXorY.create(this.mode, ug, this.piecewiseAffineTransform));
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        if (this.cachedMinMax == null) {
            this.cachedMinMax = TextBlockUtils.getMinMax(this, stringBounder, false);
        }
        return this.cachedMinMax;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.textBlock.calculateDimension(stringBounder);
        if (this.mode == CompressionMode.ON_X) {
            return new XDimension2D(this.piecewiseAffineTransform.transform(dim.getWidth()), dim.getHeight());
        }
        return new XDimension2D(dim.getWidth(), this.piecewiseAffineTransform.transform(dim.getHeight()));
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }
}

