/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.compress;

import znaishaded.net.sourceforge.plantuml.klimt.UBackground;
import znaishaded.net.sourceforge.plantuml.klimt.UChange;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UShape;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.compress.CompressionMode;
import znaishaded.net.sourceforge.plantuml.klimt.compress.SlotSet;
import znaishaded.net.sourceforge.plantuml.klimt.compress.UShapeIgnorableForCompression;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.TextLimitFinder;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicNo;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEmpty;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;
import znaishaded.net.sourceforge.plantuml.utils.ObjectUtils;

public class SlotFinder
extends UGraphicNo {
    private final SlotSet slot;
    private final CompressionMode mode;

    @Override
    public UGraphic apply(UChange change) {
        if (!ObjectUtils.instanceOfAny(change, UBackground.class, HColor.class, UStroke.class, UTranslate.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        UTranslate tmp = change instanceof UTranslate ? this.getTranslate().compose((UTranslate)change) : this.getTranslate();
        SlotFinder result = new SlotFinder(this.getStringBounder(), tmp, this.slot, this.mode);
        return result;
    }

    public static SlotFinder create(CompressionMode mode, StringBounder stringBounder) {
        return new SlotFinder(stringBounder, UTranslate.none(), new SlotSet(), mode);
    }

    private SlotFinder(StringBounder stringBounder, UTranslate translate, SlotSet slot, CompressionMode mode) {
        super(stringBounder, translate);
        this.slot = slot;
        this.mode = mode;
    }

    public void draw(UShape sh) {
        UShapeIgnorableForCompression shape;
        double x = this.getTranslate().getDx();
        double y = this.getTranslate().getDy();
        if (sh instanceof UShapeIgnorableForCompression && (shape = (UShapeIgnorableForCompression)sh).isIgnoreForCompressionOn(this.mode)) {
            shape.drawWhenCompressed(this, this.mode);
            return;
        }
        if (sh instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)sh);
        } else if (sh instanceof UPath) {
            this.drawPath(x, y, (UPath)sh);
        } else if (sh instanceof UPolygon) {
            this.drawPolygon(x, y, (UPolygon)sh);
        } else if (sh instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)sh);
        } else if (sh instanceof UText) {
            UText text = (UText)sh;
            this.drawText(x, y, text);
        } else if (sh instanceof UEmpty) {
            this.drawEmpty(x, y, (UEmpty)sh);
        }
    }

    private void drawPath(double x, double y, UPath shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        } else {
            this.slot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    private void drawText(double x, double y, UText shape) {
        TextLimitFinder finder = TextLimitFinder.create(this.getStringBounder(), false);
        finder.apply(new UTranslate(x, y)).draw(shape);
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(finder.getMinX(), finder.getMaxX());
        } else {
            this.slot.addSlot(finder.getMinY(), finder.getMaxY());
        }
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    private void drawPolygon(double x, double y, UPolygon shape) {
        if (this.mode == shape.getCompressionMode()) {
            return;
        }
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        } else {
            this.slot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
        }
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.slot.addSlot(x, x + shape.getWidth());
        } else {
            this.slot.addSlot(y, y + shape.getHeight());
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        return ColorMapper.IDENTITY;
    }

    public SlotSet getSlotSet() {
        return this.slot;
    }
}

