/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.atom;

import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;

public class Bullet
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final int order;

    public Bullet(FontConfiguration fontConfiguration, int order) {
        this.fontConfiguration = fontConfiguration;
        this.order = order;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color = this.fontConfiguration.getColor();
        ug = ug.apply(color).apply(color.bg()).apply(UStroke.withThickness(0.0));
        if (this.order == 0) {
            ug = ug.apply(UTranslate.dx(3.0));
            ug.draw(UEllipse.build(5.0, 5.0));
        } else {
            ug = ug.apply(UTranslate.dx(1 + 8 * this.order));
            ug.draw(URectangle.build(3.5, 3.5));
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.order == 0) {
            return new XDimension2D(12.0, 5.0);
        }
        return new XDimension2D(8 + 8 * this.order, 3.0);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        if (this.order == 0) {
            return -5.0;
        }
        return -7.0;
    }
}

