/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Parser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleImg
implements Command {
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleImg() {
    }

    public static Command create() {
        return new CommandCreoleImg();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String src = m3.group(2);
        double scale = Parser.getScale(m3.group(3), 1.0);
        if (src.toLowerCase().startsWith("src=")) {
            src = src.substring(4);
        }
        src = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(src, "\"");
        stripe.addImage(src, scale);
        return line.substring(m3.group(1).length());
    }
}

