/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing;

import znaishaded.net.sourceforge.plantuml.klimt.UBackground;
import znaishaded.net.sourceforge.plantuml.klimt.UChange;
import znaishaded.net.sourceforge.plantuml.klimt.UShape;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicNo;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMaxMutable;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;
import znaishaded.net.sourceforge.plantuml.utils.ObjectUtils;

public class TextLimitFinder
extends UGraphicNo {
    private final MinMaxMutable minmax;

    @Override
    public UGraphic apply(UChange change) {
        if (!ObjectUtils.instanceOfAny(change, UBackground.class, HColor.class, UStroke.class, UTranslate.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        UTranslate tmp = change instanceof UTranslate ? this.getTranslate().compose((UTranslate)change) : this.getTranslate();
        return new TextLimitFinder(this.getStringBounder(), tmp, this.minmax);
    }

    public static TextLimitFinder create(StringBounder stringBounder, boolean initToZero) {
        return new TextLimitFinder(stringBounder, UTranslate.none(), MinMaxMutable.getEmpty(initToZero));
    }

    private TextLimitFinder(StringBounder stringBounder, UTranslate translate, MinMaxMutable minmax) {
        super(stringBounder, translate);
        this.minmax = minmax;
    }

    public void draw(UShape shape) {
        if (shape instanceof UText) {
            double x = this.getTranslate().getDx();
            double y = this.getTranslate().getDy();
            this.drawText(x, y, (UText)shape);
        }
    }

    private void drawText(double x, double y, UText text) {
        XDimension2D dim = this.getStringBounder().calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.minmax.addPoint(x, y -= dim.getHeight() - 1.5);
        this.minmax.addPoint(x, y + dim.getHeight());
        this.minmax.addPoint(x + dim.getWidth(), y);
        this.minmax.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }
}

