/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.geom;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.geom.BezierUtils;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PointDirected;
import znaishaded.net.sourceforge.plantuml.klimt.geom.Side;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class RectangleArea {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public RectangleArea(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public static RectangleArea build(XPoint2D pt1, XPoint2D pt2) {
        return new RectangleArea(MathUtils.min(pt1.x, pt2.x), MathUtils.min(pt1.y, pt2.y), MathUtils.max(pt1.x, pt2.x), MathUtils.max(pt1.y, pt2.y));
    }

    public RectangleArea move(double deltaX, double deltaY) {
        return new RectangleArea(this.minX + deltaX, this.minY + deltaY, this.maxX + deltaX, this.maxY + deltaY);
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public boolean contains(double x, double y) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY;
    }

    public RectangleArea merge(RectangleArea other) {
        return new RectangleArea(Math.min(this.minX, other.minX), Math.min(this.minY, other.minY), Math.max(this.maxX, other.maxX), Math.max(this.maxY, other.maxY));
    }

    public RectangleArea merge(XPoint2D point) {
        double x = point.getX();
        double y = point.getY();
        return new RectangleArea(Math.min(this.minX, x), Math.min(this.minY, y), Math.max(this.maxX, x), Math.max(this.maxY, y));
    }

    public boolean contains(XPoint2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public String toString() {
        return "minX=" + this.minX + " maxX=" + this.maxX + " minY=" + this.minY + " maxY=" + this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public PointDirected getIntersection(XCubicCurve2D bez) {
        if (this.contains(bez.x1, bez.y1) == this.contains(bez.x2, bez.y2)) {
            return null;
        }
        double dist = bez.getP1().distance(bez.getP2());
        if (dist < 2.0) {
            double angle = BezierUtils.getStartingAngle(bez);
            return new PointDirected(bez.getP1(), angle);
        }
        XCubicCurve2D left = XCubicCurve2D.none();
        XCubicCurve2D right = XCubicCurve2D.none();
        bez.subdivide(left, right);
        PointDirected int1 = this.getIntersection(left);
        if (int1 != null) {
            return int1;
        }
        PointDirected int2 = this.getIntersection(right);
        if (int2 != null) {
            return int2;
        }
        throw new IllegalStateException();
    }

    public XPoint2D getPointCenter() {
        return new XPoint2D((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }

    public RectangleArea withMinX(double d) {
        return new RectangleArea(d, this.minY, this.maxX, this.maxY);
    }

    public RectangleArea withMaxX(double d) {
        return new RectangleArea(this.minX, this.minY, d, this.maxY);
    }

    public RectangleArea addMaxX(double d) {
        return new RectangleArea(this.minX, this.minY, this.maxX + d, this.maxY);
    }

    public RectangleArea addMaxY(double d) {
        return new RectangleArea(this.minX, this.minY, this.maxX, this.maxY + d);
    }

    public RectangleArea addMinX(double d) {
        return new RectangleArea(this.minX + d, this.minY, this.maxX, this.maxY);
    }

    public RectangleArea addMinY(double d) {
        return new RectangleArea(this.minX, this.minY + d, this.maxX, this.maxY);
    }

    public RectangleArea withMinY(double d) {
        return new RectangleArea(this.minX, d, this.maxX, this.maxY);
    }

    public RectangleArea withMaxY(double d) {
        return new RectangleArea(this.minX, this.minY, this.maxX, d);
    }

    public RectangleArea delta(double m1, double m22) {
        return new RectangleArea(this.minX, this.minY, this.maxX + m1, this.maxY + m22);
    }

    public XDimension2D getDimension() {
        return new XDimension2D(this.maxX - this.minX, this.maxY - this.minY);
    }

    public UTranslate getPosition() {
        return new UTranslate(this.getMinX(), this.getMinY());
    }

    public Side getClosestSide(XPoint2D pt) {
        double distEast;
        double distNorth = Math.abs(this.minY - pt.getY());
        double distSouth = Math.abs(this.maxY - pt.getY());
        double distWest = Math.abs(this.minX - pt.getX());
        if (this.isSmallerThan(distNorth, distWest, distEast = Math.abs(this.maxX - pt.getX()), distSouth)) {
            return Side.NORTH;
        }
        if (this.isSmallerThan(distSouth, distNorth, distWest, distEast)) {
            return Side.SOUTH;
        }
        if (this.isSmallerThan(distEast, distNorth, distWest, distSouth)) {
            return Side.EAST;
        }
        if (this.isSmallerThan(distWest, distNorth, distEast, distSouth)) {
            return Side.WEST;
        }
        return null;
    }

    private boolean isSmallerThan(double value, double a, double b, double c) {
        return value <= a && value <= b && value <= c;
    }
}

