/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.util.Collection;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.posimo.Block;
import znaishaded.net.sourceforge.plantuml.posimo.Cluster;
import znaishaded.net.sourceforge.plantuml.posimo.Path;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public class DotxMaker {
    private final Cluster root;
    private final Collection<Path> paths;

    public DotxMaker(Cluster root, Collection<Path> paths) {
        this.root = root;
        this.paths = paths;
    }

    public String createDotString(String ... dotStrings) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph unix {");
        for (String s2 : dotStrings) {
            sb.append(s2);
        }
        sb.append("compound=true;");
        this.printCluster(sb, this.root);
        for (Path p : this.paths) {
            sb.append(this.getPathString(p) + ";");
        }
        sb.append("}");
        return sb.toString();
    }

    private void printCluster(StringBuilder sb, Cluster cl) {
        if (cl.getContents().size() == 0 && cl.getSubClusters().size() == 0) {
            throw new IllegalStateException(cl.toString());
        }
        for (Cluster sub : cl.getSubClusters()) {
            sb.append("subgraph cluster" + sub.getUid() + " {");
            if (sub.getTitleWidth() > 0.0 && sub.getTitleHeight() > 0.0) {
                sb.append("label=<<TABLE FIXEDSIZE=\"TRUE\" WIDTH=\"" + sub.getTitleWidth() + "\" HEIGHT=\"" + sub.getTitleHeight() + "\"><TR><TD></TD></TR></TABLE>>");
            }
            this.printCluster(sb, sub);
            sb.append("}");
        }
        for (Block b : cl.getContents()) {
            sb.append("b" + b.getUid() + this.getNodeAttibute(b) + ";");
        }
    }

    private String getPathString(Path p) {
        Objects.requireNonNull(p);
        StringBuilder sb = new StringBuilder("b" + p.getStart().getUid() + " -> b" + p.getEnd().getUid());
        sb.append(" [dir=none, arrowhead=none, headclip=true, tailclip=true");
        int len = p.getLength();
        if (len >= 3) {
            sb.append(",minlen=" + (len - 1));
        }
        if (p.getLabel() == null) {
            sb.append("]");
        } else {
            XDimension2D size = p.getLabel().getSize();
            sb.append(", label=<<TABLE FIXEDSIZE=\"TRUE\" WIDTH=\"" + size.getWidth() + "\" HEIGHT=\"" + size.getHeight() + "\"><TR><TD></TD></TR></TABLE>>]");
        }
        if (p.getLength() <= 1) {
            boolean samePackage;
            boolean bl = samePackage = p.getStart().getParent() == p.getEnd().getParent();
            if (samePackage) {
                sb.append("{rank=same; b" + p.getStart().getUid() + "; b" + p.getEnd().getUid() + "}");
            } else {
                Log.println("!!!!!!!!!!!!!!!!!TURNING ARROUND DOT BUG!!!!!!!!!!!!!!!!!!");
            }
        }
        return sb.toString();
    }

    private String getNodeAttibute(Block b) {
        StringBuilder sb = new StringBuilder("[");
        sb.append("label=\"\",");
        sb.append("fixedsize=true,");
        sb.append("width=" + b.getSize().getWidth() / 72.0 + ",");
        sb.append("height=" + b.getSize().getHeight() / 72.0 + ",");
        sb.append("shape=rect");
        sb.append("]");
        return sb.toString();
    }
}

