/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.project.TimeHeaderParameters;
import znaishaded.net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.MonthYear;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;

public class TimeHeaderMonthly
extends TimeHeaderCalendar {
    @Override
    public double getTimeHeaderHeight() {
        return 29.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 28.0;
    }

    public TimeHeaderMonthly(TimeHeaderParameters thParam) {
        super(thParam, new TimeScaleCompressed(thParam.getStartingDay(), thParam.getScale()));
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawYears(ug);
        this.drawMonths(ug.apply(UTranslate.dy(16.0)));
        this.printSmallVbars(ug, totalHeightWithoutFooter);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, 16.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    private void printSmallVbars(UGraphic ug, double totalHeightWithoutFooter) {
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            if (this.isBold(wink)) {
                this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), this.getFullHeaderHeight(), totalHeightWithoutFooter, this.isBold(wink));
            }
            wink = wink.increment();
        }
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawMonths(ug);
        this.drawYears(ug.apply(UTranslate.dy(13.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, 13.0);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawYears(UGraphic ug) {
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (last == null || wink.monthYear().year() != last.year()) {
                this.drawVbar(ug, x1, 0.0, 15.0, false);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, 15.0, false);
    }

    private void drawMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVbar(ug, x1, 0.0, 12.0, false);
                if (last != null) {
                    this.printMonth(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChange) {
            this.printMonth(ug, last, lastChange, x1);
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, 12.0, false);
    }

    private void printYear(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock("" + monthYear.year(), 12, true, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(monthYear.shortName(this.locale()), 10, false, this.openFontColor());
        TextBlock big = this.getTextBlock(monthYear.longName(this.locale()), 10, false, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

