/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import znaishaded.net.sourceforge.plantuml.style.ISkinSimple;

public class ElementMenuPopup
extends AbstractElement {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuPopup(UFont font, ISkinSimple spriteContainer) {
        this.font = font;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String s2) {
        this.entries.add(new ElementMenuEntry(s2, this.font, this.spriteContainer));
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h2 = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            XDimension2D dim = entry.getPreferredDimension(stringBounder, x, y);
            w = Math.max(w, dim.getWidth());
            h2 += dim.getHeight();
        }
        return new XDimension2D(w, h2);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        if (zIndex != 1) {
            return;
        }
        ug = ug.apply(this.getBlack());
        ug.apply(this.getColorDD().bg()).draw(URectangle.build(dimToUse.getWidth(), dimToUse.getHeight()));
        double y1 = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            double h2 = entry.getPreferredDimension(ug.getStringBounder(), 0.0, y1).getHeight();
            if (entry.getText().equals("-")) {
                ug.apply(UTranslate.dy(y1 + h2 / 2.0)).draw(ULine.hline(dimToUse.getWidth()));
            } else {
                entry.drawU(ug.apply(UTranslate.dy(y1)), zIndex, dimToUse);
            }
            y1 += h2;
        }
    }
}

