/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.security.authentication.oauth;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.json.Json;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.security.SURL;
import znaishaded.net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import znaishaded.net.sourceforge.plantuml.security.authentication.SecurityAuthorizeManager;
import znaishaded.net.sourceforge.plantuml.security.authentication.oauth.OAuth2Tokens;

public abstract class AbstractOAuth2AccessAuthorizeManager
implements SecurityAuthorizeManager {
    protected Map<String, Object> headers() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        map.put("Accept", "application/json");
        return map;
    }

    protected Map<String, Object> buildAccessDataFromResponse(JsonObject tokenResponse, String tokenType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.toMap(map, tokenResponse, OAuth2Tokens.ACCESS_TOKEN);
        this.toMap(map, tokenResponse, OAuth2Tokens.SCOPE);
        this.toMap(map, tokenResponse, OAuth2Tokens.EXPIRES_IN);
        if (tokenType == null) {
            this.toMap(map, tokenResponse, OAuth2Tokens.TOKEN_TYPE);
            if (!map.isEmpty() && !map.containsKey(OAuth2Tokens.TOKEN_TYPE.key())) {
                map.put(OAuth2Tokens.TOKEN_TYPE.key(), "bearer");
            }
        } else if (!map.isEmpty()) {
            map.put(OAuth2Tokens.TOKEN_TYPE.key(), tokenType);
        }
        return map;
    }

    private void toMap(Map<String, Object> map, JsonObject response, OAuth2Tokens name) {
        JsonValue jsonValue = response.get(name.key());
        if (jsonValue != null && !jsonValue.isNull()) {
            if (jsonValue.isString()) {
                map.put(name.key(), jsonValue.asString());
            } else if (jsonValue.isNumber()) {
                map.put(name.key(), jsonValue.asInt());
            } else if (jsonValue.isBoolean()) {
                map.put(name.key(), jsonValue.asBoolean());
            }
        }
    }

    protected String urlEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logme.error(e);
            return data;
        }
    }

    protected SecurityAuthentication requestAndCreateAuthFromResponse(Proxy proxy, String grantType, String tokenType, SURL tokenService, String content, SecurityAuthentication basicAuth) {
        JsonValue tokenResponse;
        byte[] bytes = tokenService.getBytesOnPost(proxy, basicAuth, content, this.headers());
        if (bytes != null && (tokenResponse = Json.parse(new String(bytes, StandardCharsets.UTF_8))) != null && !tokenResponse.isNull()) {
            return new SecurityAuthentication("oauth2", null, grantType, this.buildAccessDataFromResponse(tokenResponse.asObject(), tokenType));
        }
        return null;
    }
}

