/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.Shadowable;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class EntityImageActivity
extends AbstractEntityImage {
    private double shadowing = 0.0;
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Url url;
    private final Bibliotekon bibliotekon;

    public EntityImageActivity(Entity entity, ISkinParam skinParam, Bibliotekon bibliotekon) {
        super(entity, skinParam);
        this.bibliotekon = bibliotekon;
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        HorizontalAlignment horizontalAlignment = style.getHorizontalAlignment();
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.desc = entity.getDisplay().create(fontConfiguration, horizontalAlignment, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.desc.calculateDimension(stringBounder);
        return dim.delta(20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.getShapeType() == ShapeType.ROUND_RECTANGLE) {
            ug = this.drawNormal(ug);
        } else if (this.getShapeType() == ShapeType.OCTAGON) {
            ug = this.drawOctagon(ug);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private UGraphic drawOctagon(UGraphic ug) {
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        Shadowable octagon = node.getPolygon();
        if (octagon == null) {
            return this.drawNormal(ug);
        }
        octagon.setDeltaShadow(this.shadowing);
        ug = this.applyColors(ug);
        ug.apply(UStroke.withThickness(1.5)).draw(octagon);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    private UGraphic drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal).rounded(25.0);
        rect.setDeltaShadow(this.shadowing);
        ug = this.applyColors(ug);
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        UStroke stroke = style.getStroke();
        ug.apply(stroke).draw(rect);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity).withTOBECHANGED(this.getStereo());
    }

    private UGraphic applyColors(UGraphic ug) {
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(borderColor);
        ug = ug.apply(backcolor.bg());
        return ug;
    }

    @Override
    public ShapeType getShapeType() {
        Stereotype stereotype = this.getStereo();
        if (this.getSkinParam().useOctagonForActivity(stereotype)) {
            return ShapeType.OCTAGON;
        }
        return ShapeType.ROUND_RECTANGLE;
    }
}

