/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBoxOld;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.wbs.WElement;

abstract class WBSTextBlock
extends AbstractTextBlock {
    protected final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final int level;

    public WBSTextBlock(ISkinParam skinParam, StyleBuilder styleBuilder, int level) {
        this.skinParam = skinParam;
        this.styleBuilder = styleBuilder;
        this.level = level;
    }

    protected final void drawLine(UGraphic ug, XPoint2D p1, XPoint2D p2) {
        ULine line = ULine.create(p1, p2);
        this.getStyleUsed().applyStrokeAndLineColor(ug.apply(UTranslate.point(p1)), this.skinParam.getIHtmlColorSet()).draw(line);
    }

    private Style getStyleUsed() {
        return this.getDefaultStyleDefinitionArrow().getMergedStyle(this.styleBuilder);
    }

    protected final void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        this.drawLine(ug, new XPoint2D(Math.min(x1, x2), y1), new XPoint2D(Math.max(x1, x2), y2));
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.arrow).add(SName.depth(this.level));
    }

    protected final TextBlock buildMain(WElement idea) {
        Display label = idea.getLabel();
        Style style = idea.getStyle();
        if (idea.getShape() == IdeaShape.BOX) {
            return FtileBoxOld.createWbs(style, idea.withBackColor(this.skinParam), label);
        }
        TextBlock text = label.create0(style.getFontConfiguration(this.skinParam.getIHtmlColorSet()), style.getHorizontalAlignment(), this.skinParam, style.wrapWidth(), CreoleMode.FULL, null, null);
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }
}

