/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.abel.DisplayPositioned;
import znaishaded.net.sourceforge.plantuml.command.PSystemAbstractFactory;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.jsondiagram.JsonDiagram;
import znaishaded.net.sourceforge.plantuml.jsondiagram.StyleExtractor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.style.parser.StyleParsingException;
import znaishaded.net.sourceforge.plantuml.yaml.Highlighted;
import znaishaded.net.sourceforge.plantuml.yaml.SimpleYamlParser;

public class YamlDiagramFactory
extends PSystemAbstractFactory {
    public YamlDiagramFactory() {
        super(DiagramType.YAML);
    }

    @Override
    public Diagram createSystem(UmlSource source, Map<String, String> skinParam) {
        ArrayList<Highlighted> highlighted = new ArrayList<Highlighted>();
        JsonValue yaml = null;
        StyleExtractor styleExtractor = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            styleExtractor = new StyleExtractor(source.iterator2());
            Iterator<String> it = styleExtractor.getIterator();
            it.next();
            while (true) {
                String line = it.next();
                if (!it.hasNext()) break;
                if (Highlighted.matchesDefinition(line)) {
                    highlighted.add(Highlighted.build(line));
                    continue;
                }
                list.add(line);
            }
            yaml = new SimpleYamlParser().parse(list);
        }
        catch (Exception e) {
            Logme.error(e);
        }
        JsonDiagram result = new JsonDiagram(source, UmlDiagramType.YAML, yaml, highlighted, styleExtractor);
        if (styleExtractor != null) {
            try {
                styleExtractor.applyStyles(result.getSkinParam());
            }
            catch (StyleParsingException e) {
                Logme.error(e);
            }
            String title = styleExtractor.getTitle();
            if (title != null) {
                result.setTitle(DisplayPositioned.single(Display.getWithNewlines(title), HorizontalAlignment.CENTER, VerticalAlignment.CENTER));
            }
        }
        return result;
    }
}

