/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.AnchorFeature;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetAutoTitleFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetRevealLineStopFeature;

public class SnippetsCommonFeatures {
    private final SnippetAutoTitleFeature snippetAutoTitleFeature;
    private final SnippetRevealLineStopFeature snippetRevealLineStopFeature;
    private final SnippetHighlightFeature snippetHighlightFeature;
    private final CodeReferencesFeature codeReferencesFeature;
    private final AnchorFeature anchorFeature;

    public SnippetsCommonFeatures(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, SnippetContentProvider contentProvider) {
        this.snippetAutoTitleFeature = new SnippetAutoTitleFeature(contentProvider.snippetId());
        this.snippetRevealLineStopFeature = new SnippetRevealLineStopFeature(pluginParams, contentProvider);
        this.snippetHighlightFeature = new SnippetHighlightFeature(componentsRegistry, pluginParams, contentProvider);
        this.codeReferencesFeature = new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams);
        this.anchorFeature = new AnchorFeature(componentsRegistry.docStructure(), markupPath, pluginParams);
    }

    public PluginFeatureList asList() {
        return new PluginFeatureList(this.snippetAutoTitleFeature, this.snippetRevealLineStopFeature, this.snippetHighlightFeature, this.codeReferencesFeature, this.anchorFeature);
    }
}

