/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.reveal;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.CollectionUtils;

public class ReadMoreFencePlugin
implements FencePlugin {
    private static final String TITLE_KEY = "title";
    private MarkupParserResult parserResult;

    @Override
    public String id() {
        return "readmore";
    }

    @Override
    public FencePlugin create() {
        return new ReadMoreFencePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition();
        params.add(TITLE_KEY, PluginParamType.STRING, "title to display before user clicks on it to reveal more", "\"Usage of low-level API\"");
        return params;
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser markupParser = componentsRegistry.defaultParser();
        this.parserResult = markupParser.parse(markupPath, content);
        String title = pluginParams.getOpts().getRequiredString(TITLE_KEY);
        return PluginResult.docElement("ReadMore", CollectionUtils.createMap(TITLE_KEY, title, "content", this.parserResult.contentToListOfMaps()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.parserResult.auxiliaryFiles().stream();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }
}

