/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html;

import org.testingisdocumenting.znai.core.DocMeta;
import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.html.DocumentationReactProps;
import org.testingisdocumenting.znai.html.HtmlPage;
import org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import org.testingisdocumenting.znai.html.RenderSupplier;
import org.testingisdocumenting.znai.html.reactjs.HtmlReactJsPage;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.structure.Page;
import org.testingisdocumenting.znai.structure.TocItem;

public class PageToHtmlPageConverter {
    private final DocMeta docMeta;
    private final ReactJsBundle reactJsBundle;

    public PageToHtmlPageConverter(DocMeta docMeta, ReactJsBundle reactJsBundle) {
        this.docMeta = docMeta;
        this.reactJsBundle = reactJsBundle;
    }

    public HtmlPageAndPageProps convert(TocItem tocItem, Page page, RenderSupplier mainBodySupplier) {
        String title = tocItem.isIndex() ? this.docMeta.getTitle() : this.docMeta.getTitle() + ": " + tocItem.getPageTitle();
        DocPageReactProps pageProps = new DocPageReactProps(tocItem, page);
        DocumentationReactProps docProps = new DocumentationReactProps(this.docMeta, pageProps);
        HtmlReactJsPage reactJsPage = new HtmlReactJsPage(this.reactJsBundle);
        HtmlPage htmlPage = reactJsPage.create(title, "Documentation", docProps.toMap(), mainBodySupplier, "");
        return new HtmlPageAndPageProps(htmlPage, pageProps);
    }
}

